#ifndef _TICKETING_H
#define _TICKETING_H

#include "UnityNP.h"
#include "Mutex.h"

namespace UnityPlugin
{
	struct Ticket
	{
		UInt8* data;
		int dataSize;
	};

	struct TicketEntitlementArray
	{
		void* data;
		int count;
	};

	struct TicketEntitlement
	{
		const char* id;
		int type;
		int remainingCount;  /* may be negative */
		UInt32 consumedCount;
		UInt64 createdDate;
		UInt64 expireDate;
	};

	struct TicketInfo
	{
		UInt64 issuedDate;
		UInt64 expireDate;
		UInt64 subjectAccountID;
		UInt64 statusDuration;
		int serialIDSize;
		UInt8* serialID;
		const char* subjectOnlineID;
		const char* countryCode;
		const char* subjectDomain;
		const char* serviceID;
		UInt32 issuerID;
		UInt32 languageCode;
		UInt32 subjectAge;
		int chatDisabled;
		int contentRating;
	};

	PRX_EXPORT bool PrxTicketingIsBusy();
	PRX_EXPORT bool PrxTicketingGetLastError(ResultCode* result);

	PRX_EXPORT ErrorCode PrxTicketingRequestTicket();
	PRX_EXPORT ErrorCode PrxTicketingRequestCachedTicket();
	PRX_EXPORT ErrorCode PrxTicketingGetTicket(Ticket* ticket);
	PRX_EXPORT ErrorCode PrxTicketingGetTicketInfo(const Ticket* ticket, TicketInfo* info);
	PRX_EXPORT ErrorCode PrxTicketingGetEntitlementList(const Ticket* ticket, TicketEntitlementArray* result);

	class Ticketing
	{
		SimpleLock m_Lock;
		bool m_Busy;
		ResultCode m_LastResult;
		Ticket m_Ticket;

		sce::Toolkit::NP::Utilities::Future<sce::Toolkit::NP::Ticket> m_FutureTicket;

		std::vector<SceNpEntitlement> m_Entitlements;
		std::vector<TicketEntitlement> m_EntitlementsResult;

		struct CachedTicketInfoData
		{
			UInt8 serialID[SCE_NP_TICKET_SERIAL_ID_SIZE];
			SceNpOnlineId onlineID;
			SceNpCountryCode countryCode;
			char domain[SCE_NP_SUBJECT_DOMAIN_SIZE+1];
			char serviceID[64];
		};

		CachedTicketInfoData m_InfoData;

	public:
		Ticketing();
		~Ticketing();
		bool ProcessEvent(const sce::Toolkit::NP::Event& event);

		bool IsBusy();
		ErrorCode GetLastError() const { return m_LastResult.GetResult(); }
		bool GetLastError(ResultCode* result) const { *result = m_LastResult; return m_LastResult.GetResult() == NP_OK; }

		ErrorCode RequestTicket();
		ErrorCode GetTicket(Ticket* ticket);
		ErrorCode GetTicketInfo(const Ticket* ticket, TicketInfo* info);

		ErrorCode GetTicketEntitlementList(const Ticket* ticket, TicketEntitlementArray* result);

	private:
		int NpAuthGetTicketParam(const Ticket* ticket, int paramID, SceNpTicketParam* param);
		int NpAuthGetEntitlementIdList(const Ticket* ticket, SceNpEntitlementId* entIds, int count);
		int NpAuthGetEntitlementById(const Ticket* ticket, const SceNpEntitlementId& entId, SceNpEntitlement* ent);
	};

	extern Ticketing gTicketing;
}

#endif // _COMMERCE_H
